<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('purchase_lines', function (Blueprint $table) {
            // store 'cash', 'consignment', or 'terms' (lowercase); null for legacy rows
            $table->string('mode', 20)->nullable()->index()->after('transaction_id');
        });
    }

    public function down(): void
    {
        Schema::table('purchase_lines', function (Blueprint $table) {
            $table->dropColumn('mode');
        });
    }
};
